# Logging Fields to Add (Signature / Timestamp Incidents)

This is the minimum structured logging to debug signature failures without guessing.

## Per request attempt (signed endpoints)

Log these fields:

- `ts` (ISO timestamp)
- `bot_instance_id`
- `exchange`
- `endpoint` (normalized)
- `method`
- `status`
- `error_code`
- `error_message`
- `request_id` (response header if present)
- `attempt`
- `latency_ms`

## Signature/timestamp-specific

- `local_ts_ms`
- `server_ts_ms` (if you call `serverTime`)
- `applied_offset_ms`
- `recv_window_ms`
- `signature_scheme` (HMAC_SHA256, RSA, etc.)
- `signing_version` (increment on deploy)
- `key_id` (never the secret)
- `auth_error_class` (timestamp | signature | permission | unknown)

## Context for incident correlation

- `deploy_id` (git sha or build id)
- `region`
- `host`
- `process_uptime_s`

## Example event

```json
{
  "ts": "2026-01-15T12:34:56.789Z",
  "bot_instance_id": "prod-eu-1",
  "deploy_id": "a1b2c3d",
  "exchange": "example",
  "endpoint": "private/account/balance",
  "method": "GET",
  "status": 401,
  "error_code": "timestamp_out_of_range",
  "error_message": "Timestamp for this request is outside of the recvWindow",
  "request_id": "req-123",
  "attempt": 1,
  "latency_ms": 220,
  "local_ts_ms": 1768480496789,
  "server_ts_ms": 1768480491022,
  "applied_offset_ms": -5767,
  "recv_window_ms": 5000,
  "signature_scheme": "HMAC_SHA256",
  "signing_version": "2026-01-15.1",
  "key_id": "bot-key-7",
  "auth_error_class": "timestamp",
  "region": "westeurope",
  "host": "vm-22",
  "process_uptime_s": 4312
}
```
