# Polly retry policies (shipped asset)

This package contains a minimal, production-friendly starting point for:
- exponential backoff + jitter
- timeouts (budget)
- circuit breaker
- structured retry logging

## Files
- `ResilientHttpClient.cs` – example resilient HTTP client
- `retry-policy-checklist.md` – decision checklist
- `retry-event-logging-schema.json` – suggested log schema
- `README.md` – this file

## Recommended defaults (starting point)
- Retries: 3
- Backoff: 1s, 2s, 4s (+ jitter)
- Cap: 30s
- Timeout budget: 10s per call (tune per endpoint)
- Circuit breaker: open on sustained 5xx/429

## How to use
1) Drop `ResilientHttpClient.cs` into your project.
2) Register `HttpClient` via DI and pass it in.
3) Tune retry/timeout/circuit thresholds for your dependency.
4) Emit one structured log event per retry attempt (use the JSON schema).

## Notes
- Ensure operations are idempotent before retrying.
- Concurrency limits matter as much as retries.

Full article:
- /blog/polly-retry-policies-done-right-backoff-jitter-caps-stop-rules
