# Retry-After logging fields (429 backpressure)

Goal: make throttling behavior provable.

Log at the retry decision point.

## Required fields

- `event`: `http.retry.decision`
- `dependency`: vendor name or host
- `route`: normalized route or operation name
- `status`: 429
- `retry_after_ms`: parsed Retry-After value (ms), or null
- `retry_delay_ms`: applied delay after caps/jitter (ms), or null
- `attempt`: attempt number
- `total_elapsed_ms`: elapsed time for this operation so far
- `budget_ms`: total time budget
- `decision`: `delay-and-retry` | `fail-fast` | `degrade` | `escalate`
- `correlation_id`: request correlation id

## Optional but useful

- `retry_after_source`: `delta-seconds` | `http-date`
- `cap_applied`: true/false
- `jitter_ms`: applied jitter
- `http_method`
- `status_family`: 4xx/5xx
- `exception_type` (if retry decision is based on exceptions)

## Queries you should be able to run

- 429 rate by dependency and route
- average applied delay by dependency and route
- amplification ratio: retries / original calls
- 95th percentile total elapsed time for throttled operations
