# HttpClient 429 + Retry-After package

Use this package when a dependency starts returning HTTP 429 (Too Many Requests) and your retries are making latency, queueing, and timeouts worse.

## What this package is for

- You are being throttled.
- You need to respect backpressure.
- You need bounded behavior you can prove in logs.

## Files

- `RetryAfterDelegatingHandler.cs`
  - A small DelegatingHandler that understands `Retry-After` in both forms (delta seconds and HTTP date).
  - It does **not** try to be a full retry framework. Pair it with attempt caps and budgets.

- `429-retry-after-runbook.md`
  - Operator-grade runbook for diagnosing sustained throttling and containing blast radius.

- `retry-after-logging-fields.md`
  - A compact list of log fields that lets you prove you honored backpressure.

## Recommended integration pattern

- Prefer wiring this per dependency, not globally.
- Add a per-attempt timeout and a total budget.
- Retry 429 only for idempotent operations.

If you cannot guarantee idempotency, do not retry 429. Fail fast and surface an actionable error.

## Verification

1) Force a 429 (or test against a sandbox).
2) Confirm logs show `retry_after_ms` and `retry_delay_ms`.
3) Confirm your actual call rate to the dependency drops when 429 rises.
4) Confirm your own worker saturation and queueing improves.
