# API Key Permissions & Ban Prevention Checklist

Use this before you blame “the exchange”. Most bot bans are self-inflicted: wrong permissions, noisy traffic patterns, and repeated invalid auth.

## A. Keys, permissions, and scope

- [ ] Use **separate keys per environment** (dev/staging/prod) and per bot.
- [ ] Use **least privilege**:
  - [ ] If you only need market data, do **not** enable trading.
  - [ ] If you only need spot trading, do **not** enable futures/margin.
  - [ ] Avoid withdrawal permissions (almost never needed).
- [ ] Confirm key restrictions:
  - [ ] IP allowlist is correct and includes your current egress IP.
  - [ ] If your hosting uses NAT/rotating IPs, plan for a stable egress.
- [ ] Confirm per-endpoint entitlement:
  - [ ] Some endpoints require extra flags/agreements (region/account).
  - [ ] Validate with one manual request before deploying the bot.

## B. Auth hygiene (avoid repeated invalid requests)

- [ ] Sync time on the host (see runbook in the post).
- [ ] Validate request signing locally with a known-good test.
- [ ] On auth failure (401/403/signature errors):
  - [ ] Stop retrying immediately.
  - [ ] Open circuit breaker for that endpoint/key.
  - [ ] Escalate to investigation (it’s not a transient network error).

## C. Traffic patterns that trigger abuse systems

- [ ] Do not “spray” endpoints with parallel requests.
- [ ] Add per-endpoint concurrency limits.
- [ ] Cache data that doesn’t need per-tick refresh:
  - [ ] exchange info / symbols
  - [ ] account permissions
  - [ ] fee schedules
- [ ] Prefer websocket for high-frequency market data (if stable) but treat it as unreliable.

## D. Safe deployment practices

- [ ] Use an explicit user agent string if the API supports it.
- [ ] Use stable network egress (avoid IP churn).
- [ ] Add a kill switch: disable trading quickly without redeploy.
- [ ] Log a unique bot instance id (so you can correlate incidents).

## E. Fast triage when bans happen

- [ ] Capture: timestamp, request id, endpoint, status, error code/message.
- [ ] Compare: invalid-signature rate vs rate-limit responses.
- [ ] Check: whether failures started after a deploy/config change.
- [ ] If the platform uses ban tiers, assume each invalid request increases risk.

## Done criteria

You can say “permissions are not the problem” when:

- You verified least privilege, restrictions, and entitlements.
- You have clean auth (no signature drift).
- Your request pattern respects rate limits and avoids burst concurrency.
