# Correlation ID contract

This is the contract for correlation IDs in production.

## Header

- Name: `X-Correlation-Id`
- Format: opaque string
  - GUID is acceptable
  - ULID is preferred when you want sortability

## Generation rule

- If the inbound request already contains `X-Correlation-Id`, keep it.
- Else generate a new one.

## Propagation rule

- The correlation ID must be copied to every downstream HTTP call.
- The correlation ID must be attached to every queue message / job payload.

## Logging rule

Every log event that matters must include:

- `correlation_id`
- `operation` (normalized route or job name)
- `component` (api/worker/scheduler)

This is the minimum needed to reconstruct a request path.

## Anti-patterns

- Having multiple competing IDs (X-Request-Id, RequestId, TraceId, CorrelationId) and letting services choose different ones.
- Overwriting inbound IDs.
- Only logging correlation ID on request start but not on dependency calls or job events.
