# Correlation IDs package (HTTP + jobs)

Use this package when incidents repeat because you cannot join logs across services, queues, and jobs.

## What this package is for

- One request should be traceable across components.
- Job runs should carry the same correlation ID as the request that triggered them.
- Logs should be joinable without guesswork.

## Files

- `correlation-id-contract.md`
  - The rules every service follows.

- `AspNetCoreCorrelationIdMiddleware.cs`
  - Inbound request correlation for ASP.NET Core.

- `CorrelationIdDelegatingHandler.cs`
  - Outbound propagation for HttpClient.

## Integration notes

- Pick one header name (`X-Correlation-Id`) and standardize it.
- If an inbound ID exists, keep it. If not, generate one.
- Always include it in response headers.
- Always propagate to downstream calls and job messages.

## Verification

- Pick one request.
- Confirm you can find request start, dependency calls, and job start logs using one correlation ID.
- If you cannot, correlation is dying at a boundary. Fix propagation there.
