---
title: Retry backoff + jitter recipes
summary: Copy/paste retry settings and why they work.
---

# Retry backoff + jitter recipes

These recipes are written for systems that make outbound calls (HTTP APIs, DB proxies, queues, email providers) where bursty retries can turn a small incident into a full outage.

## Defaults that rarely embarrass you

Use this when you don’t know the provider’s exact limits and you want to avoid synchronized retry storms.

- Max attempts: 3 (1 initial + 2 retries)
- Base delay: 250ms
- Backoff: exponential
- Jitter: full jitter (randomize delay)
- Max delay: 10s
- Timeout per attempt: 5–15s (depends on endpoint)

Why it works:
- You try quickly once, then back off fast.
- Jitter prevents “thundering herds” when many workers retry at the same time.
- A max delay prevents pathological waits.

## “Provider is rate-limiting us” recipe (HTTP 429)

When you see 429s, the goal is to reduce concurrent pressure, not to be stubborn.

- Respect `Retry-After` if present.
- Add concurrency limits (per host and global).
- Use exponential backoff with jitter.

Suggested:
- Max attempts: 4 (1 + 3)
- Base delay: 500ms
- Max delay: 30s
- Concurrency: cap requests per worker and cap global concurrency.

## “Transient network flake” recipe (timeouts, 5xx)

- Max attempts: 3
- Base delay: 200–300ms
- Max delay: 5–10s
- Jitter: full

If timeouts are common, don’t just add more retries; instrument latency and reduce request fanout.

## Non-retryable defaults

These should be treated as stop-now, no automatic retries:

- Authentication/authorization failures (401/403)
- Validation failures (400/422)
- Contract errors (schema mismatch)
- Safety/policy blocks

If you retry these, you’re usually amplifying a bug.
