# Loop Guardrails Checklist (AI Agents)

This checklist is designed to stop the classic failure mode: an agent that keeps trying “forever” (or until you hit rate limits, burn tokens, or annoy users).

Use it as a pre-flight before shipping an agent to production.

## A. Define what “done” means

- [ ] Explicit success criteria (what state changes = success?)
- [ ] Explicit stop conditions (what states = stop-without-success?)
- [ ] Explicit escalation conditions (when to ask a human)
- [ ] Define “no-op” detection (agent did nothing useful)

## B. Bound the work

- [ ] Max steps per run (hard cap)
- [ ] Max tool calls per run
- [ ] Max retries per tool/endpoint
- [ ] Max runtime per run (wall clock)
- [ ] Token / cost budget per run

## C. Add a loop fingerprint

Track:

- `loop_iteration`
- `last_action_type`
- `last_tool_name`
- `last_error_class`
- `last_result_hash`

Then add guardrails:

- [ ] Stop if the same error repeats N times
- [ ] Stop if the same result repeats N times
- [ ] Stop if the plan does not change after N iterations

## D. Treat failure classes differently

- [ ] Validation errors → stop (fix inputs)
- [ ] Auth/permission errors → stop + escalate
- [ ] Rate limits → retry with backoff + jitter
- [ ] Tool unavailable/outage → retry limited, then escalate
- [ ] External dependency flaky → retry limited, then degrade

## E. Enforce idempotency + safety

- [ ] Idempotency keys for side-effect tools (email, ticket, payment)
- [ ] Dedupe on user request id
- [ ] Dry-run mode for risky actions
- [ ] “Confirm before irreversible action” policy

## F. Human-in-the-loop (without breaking UX)

- [ ] Clear escalation message (what’s blocked, what’s needed)
- [ ] Provide a minimal snapshot (inputs, last actions, last errors)
- [ ] Provide a safe “resume” mechanism

## G. Observability (minimum)

Log at least:

- `run_id`, `user_id` (or anonymized)
- `goal`
- `decision` (stop | retry | escalate)
- `tool_calls_count`
- `tokens_used`
- `duration_ms`
- `error_class`
- `loop_iteration`

## Done criteria

You’re production-ready when:

- loops terminate deterministically under failures
- retries are bounded and jittered
- escalations are actionable (not “something went wrong”)
